$(function() {
	/*
	number of fieldsets
	*/
	var fieldsetCount = $('#formElem').children().length;
	console.log(fieldsetCount);
	/*
	current position of fieldset / navigation link
	*/
	var current 	= 1;
    
	/*
	sum and save the widths of each one of the fieldsets
	set the final sum as the total width of the steps element
	*/
	var stepsWidth	= 0;
    var widths 		= new Array();
	$('#steps .step').each(function(i){
        var $step 		= $(this);
		widths[i]  		= stepsWidth;
        stepsWidth	 	+= $step.width();
    });
	$('#steps').width(stepsWidth);
	
	/*
	to avoid problems in IE, focus the first input of the form
	*/
	$('#formElem').children(':first').find(':input:first').focus();	
	
	/*
	show the navigation bar
	*/
	$('#navigation').show();
	
	/*
	when clicking on a navigation link 
	the form slides to the corresponding fieldset
	*/
    $('#navigation a').bind('click',function(e){
		var $this	= $(this);
		var prev	= current;
		$this.closest('ul').find('li').removeClass('selected');
        $this.parent().addClass('selected');
		/*
		we store the position of the link
		in the current variable	
		*/
		current = $this.parent().index() + 1;
		/*
		animate / slide to the next or to the corresponding
		fieldset. The order of the links in the navigation
		is the order of the fieldsets.
		Also, after sliding, we trigger the focus on the first 
		input element of the new fieldset
		If we clicked on the last link (confirmation), then we validate
		all the fieldsets, otherwise we validate the previous one
		before the form slided
		*/
        $('#steps').stop().animate({
            marginLeft: '-' + widths[current-1] + 'px'
        },500,function(){
			console.log("current :"+ current);
			console.log("fieldsetCount :" +fieldsetCount);
			if(current == fieldsetCount)
				validateSteps();
			else
				validateStep(prev);
			$('#formElem').children(':nth-child('+ parseInt(current) +')').find(':input:first').focus();	
		});
        e.preventDefault();
    });
	
	/*
	clicking on the tab (on the last input of each fieldset), makes the form
	slide to the next step
	*/
	$('#formElem > fieldset').each(function(){
		var $fieldset = $(this);
		
		$fieldset.find('input:last').keydown(function(e){
			//console.log($fieldset.find('input:last').attr("name"));
			if (e.which == 9){
				$('#navigation li:nth-child(' + (parseInt(current)+1) + ') a').click();
				/* force the blur for validation */
				$(this).blur();
				e.preventDefault();
			}
		});
	});
	
	/*
	validates errors on all the fieldsets
	records if the Form has errors in $('#formElem').data()
	*/
	function validateSteps(){
		console.log("validateSteps");
		var FormErrors = false;
		for(var i = 1; i < fieldsetCount; ++i){
			var error = validateStep(i);
			if(error == -1)
				FormErrors = true;
		}
		$('#formElem').data('errors',FormErrors);	
	}
	
	/*
	validates one fieldset
	and returns -1 if errors found, or 1 if not
	*/
	function validateStep(step){
		console.log("validateStep");
		if(step == fieldsetCount) return;
		
		var error = 1;
		var hasError = false;
		//$('#formElem').children(':nth-child('+ parseInt(step) +')').find(':input:not(button)').each(function(){
		console.dir($('#formElem').children(':nth-child('+ parseInt(step) +')').find('input'));
		$('#formElem').children(':nth-child('+ parseInt(step) +')').find('input').not(':button,:hidden').each(function(){
			var $this 		= $(this);
			var valueLength = jQuery.trim($this.val()).length;
			//console.log($this.attr("name")+" : "+valueLength)
			if(valueLength == ''){
				hasError = true;
				$this.css('background-color','#FFEDEF');
			}
			else
				$this.css('background-color','#FFFFFF');	
		});
		var $link = $('#navigation li:nth-child(' + parseInt(step) + ') a');
		$link.parent().find('.error,.checked').remove();
		
		var valclass = 'checked';
		if(hasError){
			error = -1;
			valclass = 'error';
		}
		$('<span class="'+valclass+'"></span>').insertAfter($link);
		
		return error;
	}
	
	/*
	if there are errors don't allow the user to submit
	*/
	$('#registerButton').bind('click',function(){
		if($('#formElem').data('errors')){
			alert('Please correct the errors in the Form');
			return false;
		}
		else
		{
			var FormItem = '';
			var data = {};
			
			simpleCart.each(function (item,x) {
						var counter = x+1,
							item_options = item.options(),
							optionCount = 0,
							send;
	
						// basic item data
						data["item_name_" + counter] = item.get("name");
						data["quantity_" + counter] = item.quantity();
						data["amount_" + counter] = (item.price()*1).toFixed(2);
						data["item_number_" + counter] = item.get("item_number") || counter;
						FormItem += '<input id="item_name_' + counter + '" name="item_name_' + counter + '" value="'+item.get("name")+'" type="hidden" />';
						FormItem += '<input id="quantity_' + counter + '" name="quantity_' + counter + '" value="'+item.quantity()+'" type="hidden" />';
						FormItem += '<input id="amount_' + counter + '" name="amount_' + counter + '" value="'+(item.price()*1).toFixed(2)+'" type="hidden" />';

						// add the options
						simpleCart.each(item_options, function (val,k,attr) {
							// paypal limits us to 10 options
							if (k < 10) {
		
								// check to see if we need to exclude this from checkout
								send = true;
								simpleCart.each(settings.excludeFromCheckout, function (field_name) {
									if (field_name === attr) { send = false; }
								});
								if (send) {
										optionCount += 1;
										data["on" + k + "_" + counter] = attr;
										data["os" + k + "_" + counter] = val;
								}
	
							}
						});
						FormItem += '<input id="FormItemCount" name="FormItemCount" value="'+counter+'" type="hidden" />';
						// options count
						data["option_index_"+ x] = Math.min(10, optionCount);
					});
					
			//console.dir($('#formElem').serializeArray());
			//console.dir(data);
			//console.dir(FormItem);
			$('#formElem').append(FormItem);
			$('#formElem').submit();
		}	
	});
});