<?php get_header(); ?>

<section class="splash" style="background: url(<?php bloginfo('template_directory'); ?>/images/splash-newsblog.jpg) no-repeat center"></section><!-- end splash -->

<section class="main-content">
	
	<div class="splash-title">
		<?php if ( in_category('news-blog') ): ?>
			<h2>Ideas, Stories and Beer Talks</h2>
		<?php endif; ?>
	</div>

	<?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
			
		<div class="wrapper group">
							
			<article class="col fullwidth blog border-radius shadow">
				<?php if(get_field('cover_image') != ""): ?>
					<figure class="blog-cover">
						<a href="<?php the_permalink();?>"><img src="<?php the_field('cover_image'); ?>" alt="<?php the_title();?>" /></a>
					</figure>
				<?php endif; ?>
								
				<article class="page-content">
					<?php if(get_field('alternate_title') != ""): ?>
						<h2 class="article-title"><a href="<?php the_permalink();?>"><?php the_field('alternate_title'); ?></a></h2>
					<?php else : ?>
						<h2 class="article-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h2>
					<?php endif; ?>	
					<h3 class="post-meta">
						By <b><?php if(get_field('author_name') != ""): ?>
							<?php the_field('author_name'); ?>
						<?php else : ?>
							<?php the_author();?>
						<?php endif; ?></b>
						on <?php the_time('jS F, Y');?> | <a href="<?php the_permalink();?>#disqus_thread">Comments</a>
					</h3><!-- end post-meta -->
					<?php the_excerpt(50); ?>					
				</article><!-- end page-content -->
			</article><!-- end col -->
			
		</div><!-- end wrapper -->
	
	<?php endwhile; //end have_posts?>
</section><!-- end main-content -->			
<?php get_footer(); ?>