/*!
 * jQuery corner plugin: simple corner rounding
 * Examples and documentation at: http://jquery.malsup.com/corner/
 * version 2.13 (19-FEB-2013)
 * Requires jQuery v1.3.2 or later
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 * Authors: Dave Methvin and Mike Alsup
 */

/**
 *  corner() takes a single string argument:  $('#myDiv').corner("effect corners width")
 *
 *  effect:  name of the effect to apply, such as round, bevel, notch, bite, etc (default is round). 
 *  corners: one or more of: top, bottom, tr, tl, br, or bl.  (default is all corners)
 *  width:   width of the effect; in the case of rounded corners this is the radius. 
 *           specify this value using the px suffix such as 10px (yes, it must be pixels).
 */
(function(e){function f(t,n){return parseInt(e.css(t,n),10)||0}function l(e){e=parseInt(e,10).toString(16);return e.length<2?"0"+e:e}function c(t){while(t){var n=e.css(t,"backgroundColor"),r;if(n&&n!="transparent"&&n!="rgba(0, 0, 0, 0)"){if(n.indexOf("rgb")>=0){r=n.match(/\d+/g);return"#"+l(r[0])+l(r[1])+l(r[2])}return n}if(t.nodeName.toLowerCase()=="html")break;t=t.parentNode}return"#ffffff"}function h(e,t,n){switch(e){case"round":return Math.round(n*(1-Math.cos(Math.asin(t/n))));case"cool":return Math.round(n*(1+Math.cos(Math.asin(t/n))));case"sharp":return n-t;case"bite":return Math.round(n*Math.cos(Math.asin((n-t-1)/n)));case"slide":return Math.round(n*Math.atan2(t,n/t));case"jut":return Math.round(n*Math.atan2(n,n-t-1));case"curl":return Math.round(n*Math.atan(t));case"tear":return Math.round(n*Math.cos(t));case"wicked":return Math.round(n*Math.tan(t));case"long":return Math.round(n*Math.sqrt(t));case"sculpt":return Math.round(n*Math.log(n-t-1,n));case"dogfold":case"dog":return t&1?t+1:n;case"dog2":return t&2?t+1:n;case"dog3":return t&3?t+1:n;case"fray":return t%2*n;case"notch":return n;case"bevelfold":case"bevel":return t+1;case"steep":return t/2+1;case"invsteep":return(n-t)/2+1}}var t=/MSIE/.test(navigator.userAgent);var n=document.createElement("div").style,r=n["MozBorderRadius"]!==undefined,i=n["WebkitBorderRadius"]!==undefined,s=n["borderRadius"]!==undefined||n["BorderRadius"]!==undefined,o=document.documentMode||0,u=t&&(!o||o<8),a=t&&function(){var e=document.createElement("div");try{e.style.setExpression("width","0+0");e.style.removeExpression("width")}catch(t){return false}return true}();e.support=e.support||{};e.support.borderRadius=r||i||s;e.fn.corner=function(n){if(this.length===0){if(!e.isReady&&this.selector){var o=this.selector,l=this.context;e(function(){e(o,l).corner(n)})}return this}return this.each(function(o){var l=e(this),p=[l.attr(e.fn.corner.defaults.metaAttr)||"",n||""].join(" ").toLowerCase(),d=/keep/.test(p),v=(p.match(/cc:(#[0-9a-f]+)/)||[])[1],m=(p.match(/sc:(#[0-9a-f]+)/)||[])[1],g=parseInt((p.match(/(\d+)px/)||[])[1],10)||10,y=/round|bevelfold|bevel|notch|bite|cool|sharp|slide|jut|curl|tear|fray|wicked|sculpt|long|dog3|dog2|dogfold|dog|invsteep|steep/,b=(p.match(y)||["round"])[0],w=/dogfold|bevelfold/.test(p),E={T:0,B:1},S={TL:/top|tl|left/.test(p),TR:/top|tr|right/.test(p),BL:/bottom|bl|left/.test(p),BR:/bottom|br|right/.test(p)},x,T,N,C,k,L,A,O,M,_,D,P,H,B;if(!S.TL&&!S.TR&&!S.BL&&!S.BR)S={TL:1,TR:1,BL:1,BR:1};if(e.fn.corner.defaults.useNative&&b=="round"&&(s||r||i)&&!v&&!m){if(S.TL)l.css(s?"border-top-left-radius":r?"-moz-border-radius-topleft":"-webkit-border-top-left-radius",g+"px");if(S.TR)l.css(s?"border-top-right-radius":r?"-moz-border-radius-topright":"-webkit-border-top-right-radius",g+"px");if(S.BL)l.css(s?"border-bottom-left-radius":r?"-moz-border-radius-bottomleft":"-webkit-border-bottom-left-radius",g+"px");if(S.BR)l.css(s?"border-bottom-right-radius":r?"-moz-border-radius-bottomright":"-webkit-border-bottom-right-radius",g+"px");return}x=document.createElement("div");e(x).css({overflow:"hidden",height:"1px",minHeight:"1px",fontSize:"1px",backgroundColor:m||"transparent",borderStyle:"solid"});T={T:parseInt(e.css(this,"paddingTop"),10)||0,R:parseInt(e.css(this,"paddingRight"),10)||0,B:parseInt(e.css(this,"paddingBottom"),10)||0,L:parseInt(e.css(this,"paddingLeft"),10)||0};if(typeof this.style.zoom!==undefined)this.style.zoom=1;if(!d)this.style.border="none";x.style.borderColor=v||c(this.parentNode);N=e(this).outerHeight();for(C in E){k=E[C];if(k&&(S.BL||S.BR)||!k&&(S.TL||S.TR)){x.style.borderStyle="none "+(S[C+"R"]?"solid":"none")+" none "+(S[C+"L"]?"solid":"none");L=document.createElement("div");e(L).addClass("jquery-corner");A=L.style;k?this.appendChild(L):this.insertBefore(L,this.firstChild);if(k&&N!="auto"){if(e.css(this,"position")=="static")this.style.position="relative";A.position="absolute";A.bottom=A.left=A.padding=A.margin="0";if(a)A.setExpression("width","this.parentNode.offsetWidth");else A.width="100%"}else if(!k&&t){if(e.css(this,"position")=="static")this.style.position="relative";A.position="absolute";A.top=A.left=A.right=A.padding=A.margin="0";if(a){O=f(this,"borderLeftWidth")+f(this,"borderRightWidth");A.setExpression("width","this.parentNode.offsetWidth - "+O+'+ "px"')}else A.width="100%"}else{A.position="relative";A.margin=!k?"-"+T.T+"px -"+T.R+"px "+(T.T-g)+"px -"+T.L+"px":T.B-g+"px -"+T.R+"px -"+T.B+"px -"+T.L+"px"}for(M=0;M<g;M++){_=Math.max(0,h(b,M,g));D=x.cloneNode(false);D.style.borderWidth="0 "+(S[C+"R"]?_:0)+"px 0 "+(S[C+"L"]?_:0)+"px";k?L.appendChild(D):L.insertBefore(D,L.firstChild)}if(w&&e.support.boxModel){if(k&&u)continue;for(P in S){if(!S[P])continue;if(k&&(P=="TL"||P=="TR"))continue;if(!k&&(P=="BL"||P=="BR"))continue;H={position:"absolute",border:"none",margin:0,padding:0,overflow:"hidden",backgroundColor:x.style.borderColor};B=e("<div/>").css(H).css({width:g+"px",height:"1px"});switch(P){case"TL":B.css({bottom:0,left:0});break;case"TR":B.css({bottom:0,right:0});break;case"BL":B.css({top:0,left:0});break;case"BR":B.css({top:0,right:0});break}L.appendChild(B[0]);var j=e("<div/>").css(H).css({top:0,bottom:0,width:"1px",height:g+"px"});switch(P){case"TL":j.css({left:g});break;case"TR":j.css({right:g});break;case"BL":j.css({left:g});break;case"BR":j.css({right:g});break}L.appendChild(j[0])}}}}})};e.fn.uncorner=function(){if(s||r||i)this.css(s?"border-radius":r?"-moz-border-radius":"-webkit-border-radius",0);e("div.jquery-corner",this).remove();return this};e.fn.corner.defaults={useNative:true,metaAttr:"data-corner"}})(jQuery)