$(function() {
	
	$("#combolist input:checked").parent().addClass("selected");
	
	/* handle the user selections */
	$("#combolist .checkbox-select2").click(
		function(event) {
			event.preventDefault();
			
			$(this).closest('ul').children('li').children('a').removeClass('selected');
			$(this).addClass("selected");
  
			if($(this).hasClass('selected'))
			{
				
				$(this).closest('ul').children('a').find(":radio").removeAttr("checked");
				$(this).find(":radio").attr("checked","checked");
			}
			
			
		}
	);
	
	$(".checklist input:checked").parent().addClass("selected");
	
	/* handle the user selections */
	$(".checklist .checkbox-select").click(
		function(event) {
			event.preventDefault();
			$(this).closest('ul').children('li').removeClass('selected');
			$(this).parent().addClass("selected");
  
			if($(this).parent().hasClass('selected'))
			{
				$(this).closest('ul').children('li').find(":radio").removeAttr("checked");
				$(this).find(":radio").attr("checked","checked");
			}
	
			
		}
	);
	
	
		
	$('[placeholder]').focus(function() {
	  var input = $(this);
	  if (input.val() == input.attr('placeholder')) {
		input.val('');
		input.removeClass('placeholder');
	  }
	}).blur(function() {
	  var input = $(this);
	  if (input.val() == '' || input.val() == input.attr('placeholder')) {
		input.addClass('placeholder');
		input.val(input.attr('placeholder'));
	  }
	}).blur();
	
	/*
	number of fieldsets
	*/
	var fieldsetCount = $('#formElem').children().length;
	
	/*
	current position of fieldset / navigation link
	*/
	var current 	= 1;
    
	/*
	sum and save the widths of each one of the fieldsets
	set the final sum as the total width of the steps element
	*/
	var stepsWidth	= 0;
    var widths 		= new Array();
	/*$('#steps .step').each(function(i){
        var $step 		= $(this);
		widths[i]  		= stepsWidth;
        stepsWidth	 	+= $step.width();
    });
	$('#steps').width(stepsWidth);*/
	
	/*
	to avoid problems in IE, focus the first input of the form
	*/
	$('#formElem').children(':first').find(':input:first').focus();	
	
	/*
	show the navigation bar
	*/
	$('#navigation').show();
	
	/*
	when clicking on a navigation link 
	the form slides to the corresponding fieldset
	*/
	$('#agreed').bind('click',function(e){
		
		if ($(this).is(':checked') == true)
		{
			$('#registerButton').removeAttr("disabled");
		}
		else if ($(this).is(':checked') == false)
		 {
			 $('#registerButton').attr('disabled', '');
		 }
		
	});
	
	$('#BtnNext').bind('click',function(e){
		var $this	= $('#navigation a');
		var prev	= current;
		
		
		$this.closest('ul').find('li').removeClass('selected');
		current = $this.parent().index() + 1;
		$this.closest('ul').find('li').slice(current-1).addClass('selected');
		//$this.parent().addClass('selected');
		
		 $('#steps').stop().animate({
            marginLeft: '-' + widths[current-1] + 'px'
        },500,function(){
			if(current == fieldsetCount)
				validateSteps();
			else
				validateStep(prev);
			$('#formElem').children(':nth-child('+ parseInt(current) +')').find(':input:first').focus();	
		});
        e.preventDefault();
    });
	
	$('#BtnBack').bind('click',function(e){
		var $this	= $('#navigation a');
		var prev	= current;
		
		
		$this.closest('ul').find('li').removeClass('selected');
		current = $this.parent().index() - 1;
		$this.closest('ul').find('li').slice(current,1).addClass('selected');
		//$this.parent().addClass('selected');
		
		 $('#steps').stop().animate({
            marginLeft: '+' + widths[current] + 'px'
        },500,function(){
			if(current == fieldsetCount)
				validateSteps();
			else
				validateStep(prev);
			$('#formElem').children(':nth-child('+ parseInt(current) +')').find(':input:first').focus();	
		});
        e.preventDefault();
    });
	
	
	
    $('#navigation a').bind('click',function(e){
		var $this	= $(this);
		var prev	= current;
		$this.closest('ul').find('li').removeClass('selected');
        $this.parent().addClass('selected');
		/*
		we store the position of the link
		in the current variable	
		*/
		
		current = $this.parent().index() + 1;
		
		/*
		animate / slide to the next or to the corresponding
		fieldset. The order of the links in the navigation
		is the order of the fieldsets.
		Also, after sliding, we trigger the focus on the first 
		input element of the new fieldset
		If we clicked on the last link (confirmation), then we validate
		all the fieldsets, otherwise we validate the previous one
		before the form slided
		*/
        $('#steps').stop().animate({
            marginLeft: '-' + widths[current-1] + 'px'
        },500,function(){
			
		
			
			if(current == fieldsetCount)
				validateSteps();
			else
				validateStep(prev);
			$('#formElem').children(':nth-child('+ parseInt(current) +')').find(':input:first').focus();	
		});
        e.preventDefault();
    });
	
	/*
	clicking on the tab (on the last input of each fieldset), makes the form
	slide to the next step
	*/
	$('#formElem > fieldset').each(function(){
		var $fieldset = $(this);
		
		$fieldset.find('input:last').keydown(function(e){
			//console.log($fieldset.find('input:last').attr("name"));
			if (e.which == 9){
				$('#navigation li:nth-child(' + (parseInt(current)+1) + ') a').click();
				/* force the blur for validation */
				$(this).blur();
				e.preventDefault();
			}
		});
	});
	
	/*
	validates errors on all the fieldsets
	records if the Form has errors in $('#formElem').data()
	*/
	function validateSteps(){
		
		var FormErrors = false;
		console.log(fieldsetCount);
		for(var i = 1; i < fieldsetCount; ++i){
			var error = validateStep(i);
			if(error == -1)
				FormErrors = true;
		}
		$('#formElem').data('errors',FormErrors);	
	}
	
	/*
	validates one fieldset
	and returns -1 if errors found, or 1 if not
	*/
	function validateStep(step){
		
		if(step == fieldsetCount) return;
		
		var error = 1;
		var hasError = false;
		//$('#formElem').children(':nth-child('+ parseInt(step) +')').find(':input:not(button)').each(function(){

		$('#formElem').children(':nth-child('+ parseInt(step) +')').find('input').not(':button,:hidden').each(function(){
			var $this 		= $(this);
			var valueLength = jQuery.trim($this.val()).length;
			//console.log($this.attr("name")+" : "+valueLength)
			if(valueLength == ''){
				hasError = true;
				$this.css('background-color','#FFEDEF');
			}
			else
				$this.css('background-color','#FFFFFF');	
		});
		var $link = $('#navigation li:nth-child(' + parseInt(step) + ') a');
		$link.parent().find('.error,.checked').remove();
		
		var valclass = 'checked';
		if(hasError){
			error = -1;
			valclass = 'error';
			
		}
		$('<span class="'+valclass+'"></span>').insertAfter($link);
		
		return error;
	}
	
	var input = $(':input','#formElem').not(':button, :submit, :reset, :hidden,#ChequeNo,#Bank')

	$("input[name=PayType]:radio").bind( "change", function(event, ui) {
		if ($(this).val() == "Cheque"){
			$("#ChequeOption").slideDown("slow");
			 input = $(':input','#formElem').not(':button, :submit, :reset, :hidden')
		}
		else
			{
			$("#ChequeOption").slideUp();
			 input = $(':input','#formElem').not(':button, :submit, :reset, :hidden,#ChequeNo,#Bank')
			}
	});

	/*
	if there are errors don't allow the user to submit
	*/
	// Place ID's of all required fields here.
	required = ["Fname","Lname", "email"];
	// If using an ID other than #email or #error then replace it here
	email = $("#email");
	errornotice = $("#error");
	// The text to show up within a field when it is incorrect
	emptyerror = "Please fill out this field.";
	emailerror = "Please enter a valid e-mail.";
	
	$('#registerButton').bind('click',function(){
		//Validate required fields
		//for (i=0;i<required.length;i++) {
			input.each(function() {			
 			//var input = $('#'+required[i]);
			if (($(this).val() == "") || ($(this).val() == emptyerror)) {
				$(this).addClass("needsfilled");
				$(this).attr("placeholder", emptyerror);
				$(this).focus()
				//errornotice.fadeIn(750);
			} else {
				$(this).removeClass("needsfilled");
			}
		})
		
		// Validate the e-mail.
		if (!/^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/.test(email.val())) {
			email.addClass("needsfilled");
			email.val("");
			email.attr("placeholder", emailerror);
		}

		//if any inputs on the page have the class 'needsfilled' the form will not submit
		if ($(":input").hasClass("needsfilled")) {
			return false;
		} else {
			//errornotice.hide();
				return true;
		}	
		
		
		return false;
		
	});
});