angular.module('yoonicApp', ['ui.router', 'yoonicApp.controllers','fundoo.services']);

angular.module('yoonicApp').config(function($stateProvider,$httpProvider) {
  $httpProvider.defaults.useXDomain = true;
  delete $httpProvider.defaults.headers.common['X-Requested-With'];
  $httpProvider.defaults.headers.post['Access-Control-Allow-Origin'] = 'true';
  $stateProvider.state('medias', { // state for showing all movies
    url: '/get',
    templateUrl: 'partials/movies.html',
    controller: 'MediaListController'
  }).state('viewMedia', { //state for showing single movie
    url: '/getIndividual/:id/:url' ,
    templateUrl: 'partials/detail.html',
    controller: 'MediaViewController'
  }).state('newMedia', { //state for adding a new movie
    url: '/create',
    templateUrl: 'partials/movie-add.html',
    controller: 'MediaCreateController'
  }).state('editMedia', { //state for updating a movie
    url: '/edit/:id',
    templateUrl: 'partials/movie-edit.html',
    controller: 'MediaEditController'
  });
}).run(function($state) {
  $state.go('medias'); //make a transition to movies state when app starts
});