<!DOCTYPE html>
<!--[if IE 6]>
<html id="ie6" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 7]>
<html id="ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html id="ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 6) | !(IE 7) | !(IE 8)  ]><!-->

<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<!-- <meta name="viewport" content="width=1000"> -->
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?php bloginfo('name'); ?> &raquo; <?php wp_title(); ?></title>

<!--[if lt IE 9]><html class="ie"><![endif]-->
<link rel="stylesheet" href="<?php bloginfo('template_directory'); ?>/css/flexslider.css" type="text/css" media="screen" />
<link href="<?php bloginfo('template_directory'); ?>/style.css" rel="stylesheet" type="text/css" />
<link href="<?php bloginfo('template_directory'); ?>/style-respond.css" rel="stylesheet" type="text/css" />

<link rel="shortcut icon" type="image/x-icon" href="<?php bloginfo('template_directory'); ?>/favicon.ico">

<script src="<?php bloginfo('template_directory'); ?>/js/modernizr-2.0.6.min.js"></script>
<script src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.js"></script>

<script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/js/jquery.flexslider-min.js"></script>

<!-- Add fancyBox main JS and CSS files -->
<script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/js/jquery.fancybox.min.js?v=2.1.5"></script>
<link rel="stylesheet" type="text/css" href="<?php bloginfo('template_directory'); ?>/css/jquery.fancybox.css?v=2.1.5" media="screen" />

<!--[if lt IE 9]>
<script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/js/jquery.corner.min.js"></script>
<script>
$('.border-radius').corner("10px");
$('nav ul li a').corner("5px");
</script>
<![endif]-->

<!--[if lt IE 9]>
<link href="<?php bloginfo('template_directory'); ?>/style-ie.css" rel="stylesheet" type="text/css" />
<![endif]-->
  
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?> id="<?php echo $swatch; ?>">

	<header class="header group">
		<h1 class="logo"><a href="<?php bloginfo('url'); ?>"><img src="<?php bloginfo('template_directory'); ?>/images/logo.png" alt="<?php bloginfo('name'); ?> Logo"/></a></h1>
		<div class="nav-toggle"></div>
		<nav class="desktop" class="group" role="navigation">
			<ul class="menubg group">
				<?php wp_list_pages('exclude=2&sort_column=ID&sort_order=desc&title_li=&depth=1&link_before=<span></span>'); ?>
			</ul>
		</nav>
		<nav class="group mobile" role="navigation">
			<ul class="menubg group">
				<?php wp_list_pages('&title_li=&depth=1&link_before=<span></span>'); ?>
			</ul>
		</nav>			
	</header>