<?php 
/* Template Name: Sub Pages */ 
?>
<?php get_header(); ?>

<section class="splash short" style="background: #303030 url(<?php the_field('splash_image'); ?>) no-repeat center top">
	<h2>
	<?php if(get_field('alternate_title') != ""): ?>
		<?php the_field('alternate_title'); ?>
	<?php else : ?>
		<?php the_title();?>
	<?php endif; ?>
	</h2>
	<?php if(get_field('title_blurb') != ""): ?>
		<p><?php the_field('title_blurb'); ?></p>
	<?php endif; ?>
</section><!-- end splash -->

<section class="main-content">
	
	<?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
								
		<section class="wrapper group">
						
			<article class="page-content">
				
				<?php if(get_field('full_width') != ""): ?>
					<section class="section-row">
						<?php the_field('full_width'); ?>
					</section><!-- end section-row -->
				<?php endif; ?>
				
				<?php if( get_field('columnized_contents') ): ?>
					<?php while( has_sub_field('columnized_contents') ): ?> 
						<section class="section-row group">
							<article class="col half">
								<?php the_sub_field('left_content'); ?>
							</article>
							
							<article class="col half right">
								<?php the_sub_field('right_content'); ?>
							</article>
						</section>
					<?php endwhile; ?>
				<?php endif; ?>
								
				<?php if( get_field('our_process') ): ?>
					<?php while( has_sub_field('our_process') ): ?> 
						<section class="section-row group">
							<figure>
								<img src="<?php the_sub_field('image'); ?>" alt="<?php the_sub_field('title'); ?>" />
							</figure>
						    <div class="info">
						    	<?php the_sub_field('content'); ?>
						    </div><!-- end info -->
						</section><!-- end section-row -->
					<?php endwhile; ?>
				<?php endif; ?>
				
				<?php the_content(); ?>
				
				
			</article><!-- end page-content -->	

		</section><!-- end wrapper -->
							
	<?php endwhile; //end have_posts?>
</section><!-- end main-content -->	
		
<?php get_footer(); ?>