<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
session_start(); //we need to call PHP's session object to access it through CI
class Frontpage extends CI_Controller {

	public function __construct(){
		parent::__construct();
		$this->load->model('pitis3_manager_model');
	}
	public function index(){
		 if($this->session->userdata('logged_in')){
		 	$session_data = $this->session->userdata('logged_in');
		 	$user_id = $session_data['id'];
	    	$user_role = $session_data['role'];
	    	require_once('menu_controller.php');
			$menulist=array();
			$menu=new Menu_Controller();
			$menulist=$menu->check_menu($user_role);
	    	$this->load->view('template/header',$menulist);
       		$this->load->view('frontpage');
      		$this->load->view('include/footer'); }
      		else{
      			redirect('login', 'refresh');
      		}
	}

	public function createuser(){

		if(empty($_POST['emailaddress'])){

			$this->newuser();
		}
				
		else{
				$email=$_POST['emailaddress'];
				$result=$this->pitis3_manager_model->get_user_by_email($email);
				if($result){
					$status="Invalid Email";
					$this->newuser($status);
				}else{
					$_data['username']=$_POST["username"];
					$_data['email']=$_POST["emailaddress"];
					$_data['password']=$_POST["userpassword"];
					$_data['accesslevel_id']=$_POST['accesslevel_id'];
					$inserid=$this->pitis3_manager_model->insert_new_user($_data);
					$this->newuser();
				}
		}
	}
	public function get_profile(){

		if($this->session->userdata('logged_in')){
			$session_data=$this->session->userdata('logged_in');
			$user_id=$session_data['id'];
			$user_role=$session_data['role'];
			$_data['user']=$this->pitis3_manager_model->show_user_by($user_id);
			$_data['role']=$this->pitis3_manager_model->show_role_by($user_role);
			require_once('menu_controller.php');
			$menu_list=array();
			$menu=new Menu_Controller();
			$menulist=$menu->check_menu($user_role);
			$this->load->view('template/header',$menulist);
			$this->load->view('pages/user_admin_profile',$_data);
			$this->load->view('include/footer');
		}
	}
	public function change_password(){
			$_data['id']=$_POST['userid'];
			if(!empty($_POST["newpassword"])){
				$_data['password']=$_POST["newpassword"];
				$this->pitis3_manager_model->update_user($_data);
				$this->sendemail();
			}else{
				$this->get_profile();
			}
			
	}

	public function show_user_by($id){
		$_data['user']=$this->pitis3_manager_model->show_user_by($id);
		$_data['role']=$this->pitis3_manager_model->get_role_by();
		$data["delete_status"]=true;
		if($this->session->userdata('logged_in')){
			$session_data=$this->session->userdata('logged_in');
			$user_id=$session_data['id'];
			$user_role=$session_data['role'];
			require_once('menu_controller.php');
			$menu_list=array();
			$menu=new Menu_Controller();
			$menulist=$menu->check_menu($user_role);
			$this->load->view('template/header',$menulist);
			$this->load->view('pages/update_admin_user',$_data);
			$this->load->view('include/footer');
		}
}
public function updateuser(){
			$_data['id']=$_POST['id'];
			$_data['username']=$_POST["username"];
			$_data['email']=$_POST["emailaddress"];
			$_data['password']=$_POST["userpassword"];
			$_data['accesslevel_id']=$_POST['accesslevel_id'];
			$this->pitis3_manager_model->update_user($_data);		
			$this->newuser();
	}
	public function newuser($status=null){
		$_data['role']=$this->pitis3_manager_model->get_role_by();
		$_data['user']=$this->pitis3_manager_model->get_all_user();
		$_data['delete_status']='delete_status';
		$_data['validate_status']=$status;
		if($this->session->userdata('logged_in')){
			$session_data=$this->session->userdata('logged_in');
			$user_id=$session_data['id'];
			$user_role=$session_data['role'];
			require_once('menu_controller.php');
			$menu_list=array();
			$menu=new Menu_Controller();
			$menulist=$menu->check_menu($user_role);
			$this->load->view('template/header',$menulist);
			$this->load->view('pages/entry_newuser',$_data);
			$this->load->view('pages/show_all_admin_user',$_data);
			$this->load->view('include/footer');
		}
	}
	public function delete_admin($id=null){
		if($id!=null){
			$this->pitis3_manager_model->delete_user($id);
		}
		$this->newuser();
	}
	 function logout()
 	{
   		$this->session->unset_userdata('logged_in');
   	 	session_destroy();
  		redirect('login', 'refresh');
 	}
 	public function sendemail()
 	{	
 		if(count($_POST)>0)
 		{
 			$useremail = $_POST['email'];
 			$user = $this->pitis3_manager_model->finduserbyemail($useremail);
 			if($user == null ){
 				$data['errormsg'] = "The email you request is not registered yet.";
 				$this->index();
 			}else {

 		$userid = $user->id;
 		$email = $user->email;
 		$this->load->library('email');

		$this->email->initialize(array(
		  'protocol' => 'smtp',
		  'smtp_host' => 'smtp.sendgrid.net',
		  'smtp_user' => 'misite@e1.sg',
		  'smtp_pass' => '19mcnair',
		  'smtp_port' => 587,
		  'crlf' => "\r\n",
		  'newline' => "\r\n"
		));

		$this->email->from('sitesaw12@gmail.com', 'Pitis3 Management Team');
		$this->email->to("$email");
		 
		$this->email->subject('Email Test');
		$this->email->message("Your password have been changed");
		$is_sent = $this->email->send();
		if($is_sent)
		{
			$this->index();
		}

	}
}
}
   
}
?>
