<?php
Class Saving_category_model extends CI_Model
{
   public function __construct()
  {
    parent::__construct();
    $this->load->database('saving');
    
  }
   public function get_all_products(){
    $this->db->select('*');
    $this->db->from('saving_product');
    $this->db->order_by("id", "desc");
    $result = $this->db->get()->result();
   /* var_dump($result);die();*/
    for ($i=0; $i <count($result) ; $i++) { 
      $locid = $result[$i]->location_id;
      $locationname= $this->getlocationname($locid);
      $result[$i]->locationname = $locationname;
    }
    return $result;
  }


   public function addnewproduct($data_){
    $this->db->insert('saving_product', $data_);
  }
  public function deleteproduct($id)
  {
      return $this->db->delete('saving_product', array('id' => $id)); 
  }
   public function getproduct($id)
  {
     $this->db->select('*');
      $this->db->from('saving_product');
      $this->db->where('id' ,$id);
      $result = $this->db->get()->row();
      return $result;
  }
   public function editproduct($data)
  {     
    $this->db->where('id', $data['id']);
    unset($data['id']);
    $this->db->update('saving_product', $data);
  }

  /*********/
  public function get_all_categories(){
  	$this->db->select('*');
    $this->db->from('saving_category');
    $this->db->order_by("id", "desc");
    $result = $this->db->get()->result();
    return $result;
  }
  public function get_all_show_categories(){
    $this->db->select('*');
    $this->db->from('saving_category');
    $this->db->where('show_status','active');
    $this->db->order_by("id", "desc");
    $result = $this->db->get()->result();
    return $result;
  }
  
  public function addnewcategory($data_){
    $result = $this->db->insert('saving_category', $data_);
  }
  public function deletecategory($id)
  {
      return $this->db->delete('saving_category', array('id' => $id)); 
  }

   public function editcategory($data)
  {
     
    $this->db->where('id', $data['id']);
    unset($data['id']);
    $this->db->update('saving_category', $data);
  }
  public function getcategory($catid)
  {
     $this->db->select('*');
      $this->db->from('saving_category');
      $this->db->where('id' ,$catid);
      $result = $this->db->get()->row();
      return $result;
  }
  public function getcategoryname($catid)
  {
      $this->db->select('name');
      $this->db->from('saving_category');
      $this->db->where('id' ,$catid);
      $result = $this->db->get()->row();
      return $result->name;
  }
  /*********/
  public function get_all_locations(){
    $this->db->select('*');
    $this->db->from('saving_location');
	$this->db->order_by("id", "desc");
    $result = $this->db->get()->result();
    return $result;
  }
  public function get_show_all_locations(){
    $this->db->select('*');
    $this->db->from('saving_location');
	$this->db->where('show_status','active');
	$this->db->order_by("id", "desc");
    $result = $this->db->get()->result();
    return $result;
  }
   public function get_all_show_locations($id1,$id2,$id3){
    $query = "SELECT * from saving_location where id=$id1 or id=$id2 or id=$id3";
     
   $result = $this->db->query($query)->result();
   return $result;
    /*$this->db->select('*');
    $this->db->from('saving_location');
    $this->db->where('show_status','active');
    $this->db->order_by("id", "desc");
    $result = $this->db->get()->result();
    return $result;*/
  }

  public function addnewlocation($data_){
    $this->db->insert('saving_location', $data_);
  }
  public function deletelocation($id)
  {
      return $this->db->delete('saving_location', array('id' => $id)); 
  }
  public function editlocation($data)
  {
    
    $this->db->where('id', $data['id']);
    unset($data['id']);
    $this->db->update('saving_location', $data);
  } 
  public function getlocation($locaid)
  {
     $this->db->select('*');
      $this->db->from('saving_location');
      $this->db->where('id' ,$locaid);
      $result = $this->db->get()->row();
      return $result;
  }
 

   public function getlocationname($locid)
  {
      $this->db->select('name');
      $this->db->from('saving_location');
      $this->db->where('id' ,$locid);
      $result = $this->db->get()->row();
      return $result->name;

  }

  /* for price watch*/
public function getcategoryproducts_ids($catid){
    $this->db->select('id');
    $this->db->from('saving_product');
    $this->db->where('category_id',$catid);
    $result = $this->db->get()->result();
    return $result;
}
/*public function getcategoryproducts($catid){
    $this->db->select('*');
    $this->db->from('saving_product');
    $this->db->group_by('brand_name');
    $this->db->group_by('product_name');
    $this->db->where('category_id',$catid);
   
    $result = $this->db->get()->result();
   var_dump($result);die();
}*/
/* get unique product name and brand name */
public function getnamebrandpairs($catid)
{ 
    $query = "SELECT distinct product_name,brand_name from saving_product where category_id=$catid";
     
   $result = $this->db->query($query)->result();
   return $result;
}
public function getcategoryproduct($catid,$locid){
  $where = array('category_id'=>$catid,'location_id'=>$locid);
  $this->db->select('*');
  $this->db->from('saving_product');
  $this->db->where('category_id',$catid);
  $this->db->where('location_id',$locid);
  $result = $this->db->get()->row();
  return $result;
}

public function is_locationshow($locid){
    $this->db->select('*');
    $this->db->from('saving_location');
    $result = $this->db->where('id',$locid);
    $result = $this->db->get()->row();
    if($result->show_status=='show') return true; else return false;
  }

/* this method will return productname and brand name of an category*/
/*public function getresultproduct($catid)
{
    $categoryproducts = $this->getcategoryproducts($catid);
    $validproducts = array();
    foreach ($categoryproducts as $categoryproduct) {
    if($this->is_locationshow($categoryproduct->location_id)){
      $validproduct = new StdClass();
      //should b unique here in order to produce unique name,brand pair
      $validproduct->productname = $categoryproduct->product_name;
      $validproduct->brandname = $categoryproduct->brand_name;
      $validproduct->location_id =$categoryproduct->location_id;
      $validproducts[] = $validproduct;
    }
  }
  return $validproducts;
}*/

public function getproductinfo($productname,$brand_name,$location_id,$category_id){
//  echo $productname,$brand_name,$location_id,$category_id;die();
    $this->db->select('*');
    $this->db->from('saving_product');
    $this->db->where('brand_name',$brand_name);
    $this->db->where('product_name',$productname);
    $this->db->where('location_id',$location_id);
    $this->db->where('category_id',$category_id);
    $this->db->order_by('input_date',"desc"); 
    $result = $this->db->get()->row();
    return $result;
}

public function get_dateupdated($locid,$catid)
{
    
   $query = "SELECT MAX( input_date ) as updatedate
            FROM  `saving_product` 
            WHERE category_id =  $catid
            AND location_id =  $locid";
    
   $result = $this->db->query($query)->row();
   return $result->updatedate;
}

public function building($loc1,$loc2,$loc3)
{
  $showproducts = array();
  $showproduct = new StdClass();
  $chunkproduct = new StdClass();
  
   $locations = $this->geteachlocname($loc1,$loc2,$loc3);

  /* $namebrandquery = "SELECT id,name,brand,loc from price_watch_view where cat=10 group by name,brand";
   $namebrandpair = $this->db->query($namebrandquery)->result();
   //var_dump($namebrandpair);*/

$activecategories = $this->get_all_show_categories();
 
foreach ($activecategories as $category) {
  # code...
   $namebrandquery = "SELECT id,name,brand,loc from price_watch_view where cat=$category->id group by name,brand";
   $namebrandpair = $this->db->query($namebrandquery)->result();
   //var_dump($namebrandpair);

   $chunkproducts = array();

  $showproduct->category_name = $category->name;
  $showproduct->locations_name = $locations;

  foreach ($namebrandpair as $namebrand) {
    $chunkproduct->name = $namebrand->name;
    $chunkproduct->brand = $namebrand->brand;
      $flag ='on';

   for ($i=0; $i <count($locations) ; $i++) { 
      # code...
      
      $loc = 'price'.$i;

      $chunkprice = $this->getactiveproducts($namebrand->name,$namebrand->brand,$category->id,$locations[$i]->id);
       
      if($chunkprice != null) {$chunkproduct->$loc = $chunkprice->price; $flag='on';}
      else { $chunkproduct->$loc = '-' ;}

      

    }  
      if($flag == 'on'){
       $chunkproducts[] = $chunkproduct;
     }
       $chunkproduct = new StdClass;
       
    # code...
  }
  
    $showproduct->products = $chunkproducts;
    
    for($i=0; $i <count($locations); $i++)
    {
      $loc = 'loc'.$i.'date';
      $showproduct->$loc = $this->get_dateupdated($locations[$i]->id,$category->id);
       
    }
 
   $showproducts[] = $showproduct;
   $showproduct = new StdClass();

} 

 
  
  return $showproducts;

}
/**/


/* all active product that mean product with active location and active categories (the lastest date record)*/
public function getactiveproducts($name,$brand,$catid,$locid)
{ 
  //  echo $name;
    $this->db->select('*');
    $this->db->from('price_watch_view');
    $this->db->where('name',$name);
    $this->db->where('brand',$brand);
    $this->db->where('cat',$catid);
    $this->db->where('loc',$locid);
    $result = $this->db->get()->row();
    if(is_object($result)) { return $result;} else {return null;}
  //  var_dump($result);
     
    //return($result);
    //var_dump($this->geteachlocname('2','9','8')); 
    //$this->building();

}

/* the three locations*/
public function geteachlocname($locid1,$locid2,$locid3)
{
  $locations = array();
  
 
  $locationsinfo = array();
  $locationsinfo[0] = $this->getlocation($locid1);
  $locationsinfo[1]  = $this->getlocation($locid2);
  $locationsinfo[2]  = $this->getlocation($locid3);
  
  for ($i=0; $i <count($locationsinfo) ; $i++) { 
    # code...
    $location = new StdClass();
    $location->id = $locationsinfo[$i]->id;
    $location->name = $locationsinfo[$i]->name;
     $location->currency = $locationsinfo[$i]->currency;
    $locations[] = $location;
  }

/*  $count = 0;
  foreach ($locationsinfo as $loc) {
    # code...
    $location->id = $loc->id;
    $location->name = $loc->name;
    $locations[] = $location;
    $count++;

  }*/
  return $locations;
 

}





}