<?php
Class Saving_category_model extends CI_Model
{
   public function __construct()
  {
    parent::__construct();
    $this->load->database();
    
  }
   public function get_all_products(){
    $this->db->select('*');
    $this->db->from('saving_product');
    $this->db->order_by("id", "desc");
    $result = $this->db->get()->result();
   /* var_dump($result);die();*/
    for ($i=0; $i <count($result) ; $i++) { 
      $locid = $result[$i]->location_id;
      $locationname= $this->getlocationname($locid);
      $result[$i]->locationname = $locationname;
    }
    return $result;
  }


   public function addnewproduct($data_){
    $this->db->insert('saving_product', $data_);
  }
  public function deleteproduct($id)
  {
      return $this->db->delete('saving_product', array('id' => $id)); 
  }
   public function getproduct($id)
  {
     $this->db->select('*');
      $this->db->from('saving_product');
      $this->db->where('id' ,$id);
      $result = $this->db->get()->row();
      return $result;
  }
   public function editproduct($data)
  {     
    $this->db->where('id', $data['id']);
    unset($data['id']);
    $this->db->update('saving_product', $data);
  }

  /*********/
  public function get_all_categories(){
  	$this->db->select('*');
    $this->db->from('saving_category');
    $this->db->order_by("id", "desc");
    $result = $this->db->get()->result();
    return $result;
  }
  public function get_all_show_categories(){
    $this->db->select('*');
    $this->db->from('saving_category');
    $this->db->where('show_status','active');
    $this->db->order_by("id", "desc");
    $result = $this->db->get()->result();
    return $result;
  }
  
  public function addnewcategory($data_){
    $result = $this->db->insert('saving_category', $data_);
  }
  public function deletecategory($id)
  {
      return $this->db->delete('saving_category', array('id' => $id)); 
  }

   public function editcategory($data)
  {
     
    $this->db->where('id', $data['id']);
    unset($data['id']);
    $this->db->update('saving_category', $data);
  }
  public function getcategory($catid)
  {
     $this->db->select('*');
      $this->db->from('saving_category');
      $this->db->where('id' ,$catid);
      $result = $this->db->get()->row();
      return $result;
  }
  public function getcategoryname($catid)
  {
      $this->db->select('name');
      $this->db->from('saving_category');
      $this->db->where('id' ,$catid);
      $result = $this->db->get()->row();
      return $result->name;
  }
  
  
  
/******************************************************************************************************************/
/****************************      BUSINESS PORTION      ***************************/  

  public function get_all_business(){
    $this->db->select('*');
    $this->db->from('saving_business');
    $this->db->order_by('id', "desc");
    $result = $this->db->get()->result();
    
    return $result;
  }
  
  public function getBizDetails( $bizID )
  {
     $this->db->select('*');
      $this->db->from( 'saving_business');
      $this->db->where( 'id' ,$bizID );
      $result = $this->db->get()->row();
      return $result;
  }
  
  public function deletebiz($id)
  {
      return $this->db->delete('saving_business', array('id' => $id)); 
  }
  
  
  public function addnewBiz( $bizName, $bizDesc, $bizCurrency, $bizStatus, $bizIndustry, $bizArea )
  {
   $data = array(               
               'name' => $bizName,
	       'description' => $bizDesc,
	       'show_status' => $bizStatus,
	       'currency' => $bizCurrency,
	       'industry' => $bizIndustry,
               'area' => $bizArea	       
            );
   
    $this->db->insert('saving_business', $data);
  }
  
    
  public function editBiz($bizID, $bizName, $bizDesc, $bizCurrency, $bizStatus, $bizIndustry, $bizArea )
  {
     
    $data = array(
               'id' => $bizID,
               'name' => $bizName,
	       'description' => $bizDesc,
	       'show_status' => $bizStatus,
	       'currency' => $bizCurrency,
	       'industry' => $bizIndustry,
               'area' => $bizArea	       
            );
   
    
    $this->db->where('id', $data['id']);
    unset($data['id']);
    $this->db->update('saving_business', $data);
  } 
  
  /******************************************************************************************************************/
/****************************      Industry PORTION      ***************************/  
  
  public function get_all_industry(){
    $this->db->select('*');
    $this->db->from('saving_industry');
    $this->db->order_by('id', "desc");
    $result = $this->db->get()->result();
    
    return $result;
  }
  
  
  public function editInd( $indName, $indDesc )
  {
   $data = array(               
               'ind_name' => $indName,
	       'ind_desc' => $indDesc       
            );
   
    $this->db->where('id', $data['id']);
    unset( $data['id'] );
    $this->db->update('saving_industry', $data);
  }
  
  
  public function addnewInd( $indName, $indDesc )
  {
   $data = array(               
               'ind_name' => $indName,
	       'ind_desc' => $indDesc       
            );
   
    $this->db->insert('saving_industry', $data);
  }
  
  public function getIndDetails( $bizID )
  {
     $this->db->select('*');
      $this->db->from( 'saving_industry');
      $this->db->where( 'id' ,$bizID );
      $result = $this->db->get()->row();
      return $result;
  }
  
  public function deleteind($id)
  {
      return $this->db->delete('saving_industry', array('id' => $id)); 
  }
  
  /******************************************************************************************************************/
  
  public function get_all_locations(){
    $this->db->select('*');
    $this->db->from('saving_location');
	$this->db->order_by("id", "desc");
    $result = $this->db->get()->result();
    return $result;
  }
  
  
  
  
  public function get_show_all_locations(){
    $this->db->select('*');
    $this->db->from('saving_location');
	$this->db->where('show_status','active');
	$this->db->order_by("id", "desc");
    $result = $this->db->get()->result();
    return $result;
  }
   public function get_all_show_locations($id1,$id2,$id3){
    $query = "SELECT * from saving_location where id=$id1 or id=$id2 or id=$id3";
     
   $result = $this->db->query($query)->result();
   return $result;
    /*$this->db->select('*');
    $this->db->from('saving_location');
    $this->db->where('show_status','active');
    $this->db->order_by("id", "desc");
    $result = $this->db->get()->result();
    return $result;*/
  }

  public function addnewlocation($data_){
    $this->db->insert('saving_location', $data_);
  }
 
 
  public function deletelocation($id)
  {
      return $this->db->delete('saving_location', array('id' => $id)); 
  }
  
  
  public function editlocation( $loc_id, $loc_country, $loc_state, $loc_area, $loc_desc )
  {
    
    $data = array(
               'id' => $loc_id,
               'loc_country' => $loc_country,
               'loc_state' => $loc_state,
	       'loc_area' => $loc_area,
	       'loc_description' => $loc_desc	       
            );
    
    
    
    $this->db->where('id', $data['id']);
    unset($data['id']);
    $this->db->update('saving_location', $data);
    
  } 
  
  
  public function getlocation($locaid)
  {
     $this->db->select('*');
      $this->db->from('saving_location');
      $this->db->where('id' ,$locaid);
      $result = $this->db->get()->row();
      return $result;
  }
 

   public function getlocationname($locid)
  {
      $this->db->select('name');
      $this->db->from('saving_location');
      $this->db->where('id' ,$locid);
      $result = $this->db->get()->row();
      return $result->name;

  }
  
  
  
  
  
  
  /****************************************/
  
  
  

  /* for price watch*/
public function getcategoryproducts_ids($catid){
    $this->db->select('id');
    $this->db->from('saving_product');
    $this->db->where('category_id',$catid);
    $result = $this->db->get()->result();
    return $result;
}
/*public function getcategoryproducts($catid){
    $this->db->select('*');
    $this->db->from('saving_product');
    $this->db->group_by('brand_name');
    $this->db->group_by('product_name');
    $this->db->where('category_id',$catid);
   
    $result = $this->db->get()->result();
   var_dump($result);die();
}*/
/* get unique product name and brand name */
public function getnamebrandpairs($catid)
{ 
    $query = "SELECT distinct product_name,brand_name from saving_product where category_id=$catid";
     
   $result = $this->db->query($query)->result();
   return $result;
}
public function getcategoryproduct($catid,$locid){
  $where = array('category_id'=>$catid,'location_id'=>$locid);
  $this->db->select('*');
  $this->db->from('saving_product');
  $this->db->where('category_id',$catid);
  $this->db->where('location_id',$locid);
  $result = $this->db->get()->row();
  return $result;
}

public function is_locationshow($locid){
    $this->db->select('*');
    $this->db->from('saving_location');
    $result = $this->db->where('id',$locid);
    $result = $this->db->get()->row();
    if($result->show_status=='show') return true; else return false;
  }

/* this method will return productname and brand name of an category*/
/*public function getresultproduct($catid)
{
    $categoryproducts = $this->getcategoryproducts($catid);
    $validproducts = array();
    foreach ($categoryproducts as $categoryproduct) {
    if($this->is_locationshow($categoryproduct->location_id)){
      $validproduct = new StdClass();
      //should b unique here in order to produce unique name,brand pair
      $validproduct->productname = $categoryproduct->product_name;
      $validproduct->brandname = $categoryproduct->brand_name;
      $validproduct->location_id =$categoryproduct->location_id;
      $validproducts[] = $validproduct;
    }
  }
  return $validproducts;
}*/

public function getproductinfo($productname,$brand_name,$location_id,$category_id){
//  echo $productname,$brand_name,$location_id,$category_id;die();
    $this->db->select('*');
    $this->db->from('saving_product');
    $this->db->where('brand_name',$brand_name);
    $this->db->where('product_name',$productname);
    $this->db->where('location_id',$location_id);
    $this->db->where('category_id',$category_id);
    $this->db->order_by('input_date',"desc"); 
    $result = $this->db->get()->row();
    return $result;
}

public function get_dateupdated($locid,$catid)
{
    
   $query = "SELECT MAX( input_date ) as updatedate
            FROM  `saving_product` 
            WHERE category_id =  $catid
            AND location_id =  $locid";
    
   $result = $this->db->query($query)->row();
   return $result;

}




}