<?php get_header(); ?>

<?php if(get_field('splash_image') != ""): ?>
	<div class="splash" style="background: url(<?php the_field('splash_image'); ?>) no-repeat center"></div><!-- end splash -->
<?php else: ?>
		<div class="splash" style="background: url(<?php bloginfo('template_directory'); ?>/images/splash-newsblog.jpg) no-repeat center"></div><!-- end splash -->
<?php endif; ?>

<section class="main-content">
	
	<div class="splash-title">
			<h2>
			<?php if(get_field('alternate_title') != ""): ?>
				<?php the_field('alternate_title'); ?>
			<?php else : ?>
				<?php the_title();?>
			<?php endif; ?>
			</h2>
		
		<?php if(get_field('title_blurb') != ""): ?>
			<style>.splash-title h2 { padding-bottom: 10px; }</style>
			<p><?php the_field('title_blurb'); ?></p>
		<?php endif; ?>
		
	</div><!-- end splash-title -->

	<?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
					
		<section class="wrapper group">
			<article class="col fullwidth border-radius shadow">
				<?php if(get_field('cover_image') != ""): ?>
					<figure class="blog-cover">
						<img src="<?php the_field('cover_image'); ?>" alt="<?php the_title();?>" />
					</figure>
				<?php endif; ?>
								
				<article class="page-content">
					<?php if(get_field('alternate_title') != ""): ?>
						<h2 class="article-title"><?php the_field('alternate_title'); ?></h2>
					<?php else : ?>
						<h2 class="article-title"><?php the_title();?></h2>
					<?php endif; ?>	
					
					<?php the_content(); ?>
					
					<!-- AddThis Button BEGIN -->
					<div class="addthis_toolbox addthis_default_style ">
					<a class="addthis_button_facebook_like" fb:like:layout="button_count"></a>
					<a class="addthis_button_tweet"></a>
					<a class="addthis_button_pinterest_pinit" pi:pinit:layout="horizontal"></a>
					<a class="addthis_counter addthis_pill_style"></a>
					</div>
					<script type="text/javascript">var addthis_config = {"data_track_addressbar":true};</script>
					<script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-4fc7bbd92c74dcd7"></script>
					<!-- AddThis Button END -->
				</article><!-- end page-content -->
			</article><!-- end col -->
			
		</section><!-- end wrapper -->
	
	<?php endwhile; //end have_posts?>
</section><!-- end main-content -->			
<?php get_footer(); ?>