<?php 
/* Template Name: Full Width */ 
?>
<?php get_header(); ?>

<?php if(get_field('splash_image') != ""): ?>
	<div class="splash" style="background: url(<?php the_field('splash_image'); ?>) no-repeat center"></div><!-- end splash -->
<?php endif; ?>

<section class="main-content">
	<div class="splash-title">
			<h2>
			<?php if(get_field('alternate_title') != ""): ?>
				<?php the_field('alternate_title'); ?>
			<?php else : ?>
				<?php the_title();?>
			<?php endif; ?>
			</h2>
		
		<?php if(get_field('title_blurb') != ""): ?>
			<style>.splash-title h2 { padding-bottom: 10px; }</style>
			<p><?php the_field('title_blurb'); ?></p>
		<?php endif; ?>
	</div><!-- end splash-title -->
	
	<?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
								
		<section class="wrapper group">
			<article class="col fullwidth border-radius shadow">
			
				<article class="page-content">
					
					<?php if(get_field('full_width') != ""): ?>
						<section class="section-row">
							<?php the_field('full_width'); ?>
						</section><!-- end section-row -->
					<?php endif; ?>
					
					<?php if( get_field('columnized_contents') ): ?>
						<?php while( has_sub_field('columnized_contents') ): ?> 
							<section class="section-row group">
								<article class="col half">
									<?php the_sub_field('left_content'); ?>
								</article>
								
								<article class="col half right">
									<?php the_sub_field('right_content'); ?>
								</article>
							</section>
						<?php endwhile; ?>
					<?php endif; ?>
														
					<?php the_content(); ?>
					
				</article><!-- end page-content -->
			
			</article><!-- end col -->	

		</section><!-- end wrapper -->
							
	<?php endwhile; //end have_posts?>
</section><!-- end main-content -->	
		
<?php get_footer(); ?>