<?php
if ( function_exists('register_sidebar') )
{
	register_sidebar(array(
	  'name' => 'Primary Sidebar',
	  'id' => 'primary-sidebar',
	  'description' => 'The first distinctive sidebar blocks in the blog page',
	  'before_title' => '<h3>',
	  'after_title' => '</h3>'
	));
}

if(!function_exists('get_post_top_ancestor_id')){
/**
 * Gets the id of the topmost ancestor of the current page. Returns the current
 * page's id if there is no parent.
 * 
 * @uses object $post
 * @return int 
 */
function get_post_top_ancestor_id(){
    global $post;
    
    if($post->post_parent){
        $ancestors = array_reverse(get_post_ancestors($post->ID));
        return $ancestors[0];
    }
    
    return $post->ID;
}}

function excerpt($limit) {
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
  } else {
    $excerpt = implode(" ",$excerpt);
  }
  $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
  return $excerpt;
}

function content($limit) {
  $content = explode(' ', get_the_content(), $limit);
  if (count($content)>=$limit) {
    array_pop($content);
    $content = implode(" ",$content).'...';
  } else {
    $content = implode(" ",$content);
  }
  $content = preg_replace('/[.+]/','', $content);
  $content = apply_filters('the_content', $content);
  $content = str_replace(']]>', ']]&gt;', $content);
  return $content;
}

add_filter('wp_list_categories','highlight_single_posts_categories');
function highlight_single_posts_categories($output) {
if(is_single()) :
$categories = wp_get_post_categories(get_the_ID());
foreach ($categories as $catid) {
$cat = get_category($catid);
$cats[] = $cat->cat_ID;
 }
if($cats) { foreach($cats as $value) {
	if(preg_match('#item-' . $value . '">#', $output)) {
	$output = str_replace('item-' . $value . '">', 'item-' . $value . ' current-cat">', $output);
	}
	}
}
endif;
return $output;
}

?>