<?php get_header(); ?>

<?php if(get_field('splash_image') != ""): ?>
	<div class="splash" style="background: url(<?php the_field('splash_image'); ?>) no-repeat center"></div><!-- end splash -->
<?php else: ?>
	<?php if ( in_category('news-blog') ): ?>
		<div class="splash" style="background: url(<?php bloginfo('template_directory'); ?>/images/splash-newsblog.jpg) no-repeat center"></div><!-- end splash -->
	<?php elseif ( in_category('case-study') ): ?>
		<div class="splash" style="background: url(<?php bloginfo('template_directory'); ?>/images/splash-case.jpg) no-repeat center"></div><!-- end splash -->
	<?php endif; ?>
<?php endif; ?>

<section class="main-content">
	
	<div class="splash-title">
		<?php if ( in_category('news-blog') ): ?>
			<h2>Ideas, Stories and Beer Talks</h2>
		<?php else: ?>
			<h2>
			<?php if(get_field('alternate_title') != ""): ?>
				<?php the_field('alternate_title'); ?>
			<?php else : ?>
				<?php the_title();?>
			<?php endif; ?>
			</h2>
		<?php endif; ?>
		
		<?php if(get_field('title_blurb') != ""): ?>
			<style>.splash-title h2 { padding-bottom: 10px; }</style>
			<p><?php the_field('title_blurb'); ?></p>
		<?php endif; ?>
		
	</div><!-- end splash-title -->

	<?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
			
		<?php if ( in_category('news-blog') ): ?>
		
		<section class="wrapper group">
			<article class="col fullwidth blog border-radius shadow">
				<?php if(get_field('cover_image') != ""): ?>
					<figure class="blog-cover">
						<img src="<?php the_field('cover_image'); ?>" alt="<?php the_title();?>" />
					</figure>
				<?php endif; ?>
								
				<article class="page-content">
					<?php if(get_field('alternate_title') != ""): ?>
						<h2 class="article-title"><?php the_field('alternate_title'); ?></h2>
					<?php else : ?>
						<h2 class="article-title"><?php the_title();?></h2>
					<?php endif; ?>	
					<h3 class="post-meta">
						By <b><?php if(get_field('author_name') != ""): ?>
							<?php the_field('author_name'); ?>
						<?php else : ?>
							<?php the_author();?>
						<?php endif; ?></b>
						on <?php the_time('jS F, Y');?> | <a href="<?php the_permalink();?>#disqus_thread">Comments</a>
					</h3><!-- end post-meta -->
					<?php the_content(); ?>
					
					<!-- AddThis Button BEGIN -->
					<div class="addthis_toolbox addthis_default_style ">
					<a class="addthis_button_facebook_like" fb:like:layout="button_count"></a>
					<a class="addthis_button_tweet"></a>
					<a class="addthis_button_pinterest_pinit" pi:pinit:layout="horizontal"></a>
					<a class="addthis_counter addthis_pill_style"></a>
					</div>
					<script type="text/javascript">var addthis_config = {"data_track_addressbar":true};</script>
					<script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-4fc7bbd92c74dcd7"></script>
					<!-- AddThis Button END -->
				</article><!-- end page-content -->
			</article><!-- end col -->
			
			<article class="col fullwidth blog border-radius shadow">
				<article class="page-content">
					<div id="disqus_thread"></div>
				    <script type="text/javascript">
				        /* * * CONFIGURATION VARIABLES: EDIT BEFORE PASTING INTO YOUR WEBPAGE * * */
				        var disqus_shortname = 'e1concept'; // required: replace example with your forum shortname
				
				        /* * * DON'T EDIT BELOW THIS LINE * * */
				        (function() {
				            var dsq = document.createElement('script'); dsq.type = 'text/javascript'; dsq.async = true;
				            dsq.src = '//' + disqus_shortname + '.disqus.com/embed.js';
				            (document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')[0]).appendChild(dsq);
				        })();
				    </script>
			    </article><!-- end page-content -->
			</article>
		</section><!-- end wrapper -->
			
		<?php else: ?>
			
		<section class="wrapper group">
			
			<?php if(get_field('cover_image') != ""): ?>
				<figure class="cover">
					<img src="<?php the_field('cover_image'); ?>" alt="<?php the_title();?>" />
				</figure>
			<?php endif; ?>
			
			<article class="page-content">
				
				<?php if ( in_category('case-study') ): ?>
					<section class="group">
						<?php if(get_field('problem') != ""): ?>
							<article class="col half">
								<h2 class="article-title">The Problem</h2>
								<?php the_field('problem'); ?>
							</article>
						<?php endif; ?>
						<?php if(get_field('solution') != ""): ?>
							<article class="col half right">
								<h2 class="article-title">E1 Solution</h2>
								<?php the_field('solution'); ?>
							</article>
						<?php endif; ?>		
					</section>
				<?php endif; // end if case-study ?>
				
			</article><!-- end page-content -->
			
			<?php if(get_field('outcome') != ""): ?>
					<section class="outcome">
						<article class="center">
							<h2>Outcome</h2>
							<?php the_field('outcome'); ?>
							<?php if(get_field('website_url') != ""): ?>
								<a class="visit border-radius" href="<?php the_field('website_url'); ?>" target="_blank">- Visit Website -</a>
							<?php endif; ?>
						</article>
					</section><!-- end outcome -->
			<?php endif; ?>

			<article class="page-content">
				<?php the_content(); ?>
			</article><!-- end page-content -->	

		</section><!-- end wrapper -->
		
		<?php endif //end if news-blog ?>
				
		<div class="page-nav">
			<div class="prev"><?php previous_post_link('%link', 'Previous', TRUE); ?></div>
			<div class="next"><?php next_post_link('%link', 'Next', TRUE); ?></div>
		</div><!-- end page-nav -->
	
	<?php endwhile; //end have_posts?>
</section><!-- end main-content -->			
<?php get_footer(); ?>