<?php 
/* Template Name: Home Page */ 
?>
<?php get_header(); ?>
	
	<main class="main-content">
	
	<?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
	
		<?php if( get_field('main_carousel') ): ?>
		<article class="main-carousel group">
			<div class="flexslider">
				<ul class="slides">
					<?php while( has_sub_field('main_carousel') ): $count++ ?> 
						<li class="group">
						<?php if(get_sub_field('background_image') != ""): ?>
							<div class="banner" id="slide<?php echo $count; ?>" style="background: <?php the_sub_field('background_color'); ?> url(<?php the_sub_field('background_image'); ?>) center no-repeat;">
						<?php else: ?>
							<div class="banner" id="slide<?php echo $count; ?>" style="background: <?php the_sub_field('background_color'); ?>">
						<?php endif; ?>
							
								<div class="wrapper">
									<div class="caption">
										<img class="graphic" src="<?php the_sub_field('graphic'); ?>" alt="<?php the_sub_field('title'); ?>" />
										<h3><?php the_sub_field('title'); ?></h3>
										<p><?php the_sub_field('summary'); ?></p>
									</div><!-- end caption -->
								</div><!-- end wrapper -->	
							</div><!-- end banner -->
						</li>
						<?php $bgcolor = get_sub_field('background_color'); ?>
					<?php endwhile; ?>
				</ul>
			</div><!-- end flexslider -->
		</article><!-- end carousel -->
		<?php endif; ?>
				
		<section class="section-row intro">
			<article class="wrapper group">
				<?php the_content(); ?>
			</article><!-- end wrapper -->			
		</section><!-- end services -->
		
		<section class="section-row intro">
			<article class="wrapper group home-blocks">
				<h2><?php the_field('motto'); ?></h2>
				<?php if( get_field('home_blocks') ): ?>
					<?php while( has_sub_field('home_blocks') ): ?> 
						<a class="home-block" href="<?php the_sub_field('hyperlink'); ?>" onclick="return false;">
							<figure>
								<img src="<?php the_sub_field('image'); ?>" alt="<?php the_sub_field('title'); ?>" />
							</figure>
							<h3><?php the_sub_field('title'); ?></h2>
						</a><!-- end home-block -->
					<?php endwhile; ?>
				<?php endif; ?>
			</article><!-- end home-blocks -->			
		</section><!-- end services -->
		
		
		<?php $my_query = new WP_Query('category_name=news-blog&posts_per_page=1');
			while ($my_query->have_posts()) : $my_query->the_post();
			$do_not_duplicate = $post->ID; ?>
				<section class="news section-row">
					<article class="wrapper home-blocks group">
						<h2 class="section-row-title"><?php the_category();?></h2>
						<h3 class="article-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
						<?php if(get_field('thumbnail_paragraph') != ""): ?>
							<?php the_field('thumbnail_paragraph'); ?>
						<?php else : ?>
							<p><?php echo excerpt(50); ?></p>
						<?php endif; ?>
						<a class="readmore" href="<?php the_permalink();?>">Read More</a>
					</article><!-- end wrapper -->	
				</section><!-- end news -->
		<?php wp_reset_query(); ?>
		<?php endwhile; ?>
		
		<section class="case section-row">
			<article class="wrapper home-blocks group">
				<h2 class="section-row-title">Case Study</h2>
				<div class="case-slider flexslider">
					<ul class="slides">
						<?php $my_query = new WP_Query('category_name=case-study&posts_per_page=10');
						while ($my_query->have_posts()) : $my_query->the_post();
						$do_not_duplicate = $post->ID; ?>
						<li>
							<h3 class="article-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
							<?php if(get_field('thumbnail_paragraph') != ""): ?>
								<?php the_field('thumbnail_paragraph'); ?>
							<?php else : ?>
								<p><?php echo excerpt(10); ?></p>
							<?php endif; ?>
							<a href="<?php the_permalink();?>">
								<?php if(get_field('cover_image') != ""): ?>
									<img src="<?php the_field('cover_image'); ?>" alt="<?php the_title();?>" />
								<?php endif; ?>
							</a>
						</li>
						<?php wp_reset_query(); ?>
						<?php endwhile; ?>
					</ul>
				</div><!-- end case-slider -->
			</article><!-- end wrapper -->	
		</section><!-- end case study -->
		
		<section class="clients section-row">
			<article class="wrapper group">
				<h2 class="section-row-title">Our Clients</h2>
				<p><?php the_field('clients_liner', 'option'); ?></p>
				<?php if( get_field('client_brands', 'option') ): ?>
					<?php while( has_sub_field('client_brands', 'option') ): ?> 
						<a class="brand" href="<?php the_sub_field('hyperlink'); ?>" target="_blank">
							<figure>
								<img src="<?php the_sub_field('brand_image'); ?>" alt="<?php the_sub_field('brand_name'); ?>" />
							</figure>
						</a><!-- end home-block -->
					<?php endwhile; ?>
				<?php endif; ?>
			</article><!-- end wrapper -->			
		</section><!-- end clients -->

		
			
	<?php endwhile; ?>
				
					
	</main><!-- end main-content -->
			
<?php get_footer(); ?>