<?php
/**
 * @file
 * publisher_core.features.inc
 */

/**
 * Implements hook_ctools_plugin_api().
 */
function publisher_core_ctools_plugin_api() {
  list($module, $api) = func_get_args();
  if ($module == "field_group" && $api == "field_group") {
    return array("version" => "1");
  }
  list($module, $api) = func_get_args();
  if ($module == "strongarm" && $api == "strongarm") {
    return array("version" => "1");
  }
}

/**
 * Implements hook_views_api().
 */
function publisher_core_views_api() {
  return array("api" => "3.0");
}

/**
 * Implements hook_node_info().
 */
function publisher_core_node_info() {
  $items = array(
    'template_1' => array(
      'name' => t('Template 1'),
      'base' => 'node_content',
      'description' => '',
      'has_title' => '1',
      'title_label' => t('Section'),
      'help' => '',
    ),
    'template_2' => array(
      'name' => t('Template 2'),
      'base' => 'node_content',
      'description' => '',
      'has_title' => '1',
      'title_label' => t('Section'),
      'help' => '',
    ),
    'umessage' => array(
      'name' => t('U Message'),
      'base' => 'node_content',
      'description' => t('U message for Edition'),
      'has_title' => '1',
      'title_label' => t('Title'),
      'help' => t('This will show up at Edition home page'),
    ),
  );
  return $items;
}

/**
 * Implements hook_workflow_features_default_workflow().
 */
function publisher_core_workflow_features_default_workflow() {
  return array(
    'Publish' => array(
      'name' => 'Publish',
      'tab_roles' => '4,5',
      'options' => 'a:3:{s:16:"comment_log_node";i:1;s:15:"comment_log_tab";i:1;s:13:"name_as_title";i:0;}',
      'states' => array(
        0 => array(
          'state' => '(creation)',
          'weight' => '-50',
          'sysid' => '1',
          'status' => '1',
        ),
        1 => array(
          'state' => 'Draft',
          'weight' => '0',
          'sysid' => '0',
          'status' => '1',
        ),
        2 => array(
          'state' => 'Published',
          'weight' => '0',
          'sysid' => '0',
          'status' => '1',
        ),
        3 => array(
          'state' => 'Need Work',
          'weight' => '0',
          'sysid' => '0',
          'status' => '1',
        ),
      ),
      'transitions' => array(
        0 => array(
          'sid' => '(creation)',
          'target_sid' => 'Draft',
          'roles' => 'author,5',
        ),
        1 => array(
          'sid' => 'Draft',
          'target_sid' => 'Published',
          'roles' => '4',
        ),
        2 => array(
          'sid' => 'Draft',
          'target_sid' => 'Need Work',
          'roles' => '4',
        ),
        3 => array(
          'sid' => 'Published',
          'target_sid' => 'Need Work',
          'roles' => '4',
        ),
        4 => array(
          'sid' => 'Need Work',
          'target_sid' => 'Draft',
          'roles' => '5',
        ),
      ),
      'node_types' => array(
        0 => array(
          'type' => 'template_1',
          'wid' => '1',
        ),
        1 => array(
          'type' => 'template_2',
          'wid' => '1',
        ),
      ),
    ),
  );
}
