<?php
/**
 * @file
 * publisher_core.rules_defaults.inc
 */

/**
 * Implements hook_default_rules_configuration().
 */
function publisher_core_default_rules_configuration() {
  $items = array();
  $items['rules_send_email_to_author'] = entity_import('rules_config', '{ "rules_send_email_to_author" : {
      "LABEL" : "Send email to author (Need Work)",
      "PLUGIN" : "reaction rule",
      "TAGS" : [ "author", "email", "from any to Need Work" ],
      "REQUIRES" : [ "workflow_rules", "rules" ],
      "ON" : [ "workflow_state_changed" ],
      "IF" : [
        { "workflow_check_transition" : {
            "node" : [ "node" ],
            "old_state" : { "value" : { "ANY" : "ANY" } },
            "new_state" : { "value" : { "4" : "4" } }
          }
        }
      ],
      "DO" : [
        { "mail" : {
            "to" : "[node:author:mail]",
            "subject" : "Your post have reviewed",
            "message" : "Your post titled : [node:title] status have been changed into Need Work.\\r\\n\\r\\nYou can view the post here :  [node:url] or edit directly here : [node:edit-url] (you must logged in to open the link).\\r\\n\\r\\nCheers.",
            "language" : [ "" ]
          }
        }
      ]
    }
  }');
  $items['rules_send_email_to_author_published_'] = entity_import('rules_config', '{ "rules_send_email_to_author_published_" : {
      "LABEL" : "Send email to author (Published)",
      "PLUGIN" : "reaction rule",
      "TAGS" : [ "author", "email", "from Draft \\/ Needs work into published" ],
      "REQUIRES" : [ "workflow_rules", "rules" ],
      "ON" : [ "workflow_state_changed" ],
      "IF" : [
        { "workflow_check_transition" : {
            "node" : [ "node" ],
            "old_state" : { "value" : { "ANY" : "ANY" } },
            "new_state" : { "value" : { "3" : "3" } }
          }
        }
      ],
      "DO" : [
        { "node_publish" : { "node" : [ "node" ] } },
        { "mail" : {
            "to" : "[node:author:mail]",
            "subject" : "Your post have been published",
            "message" : "Your post titled : [node:title] have been published by the Editor team.\\r\\n\\r\\nYou can view the post here : [node:url]\\r\\n",
            "language" : [ "" ]
          }
        }
      ]
    }
  }');
  $items['rules_send_emails_to_all_editors'] = entity_import('rules_config', '{ "rules_send_emails_to_all_editors" : {
      "LABEL" : "Send emails to all Editors",
      "PLUGIN" : "reaction rule",
      "TAGS" : [ "editor", "email", "from any to draft" ],
      "REQUIRES" : [ "workflow_rules", "rules" ],
      "ON" : [ "workflow_state_changed" ],
      "IF" : [
        { "workflow_check_transition" : {
            "node" : [ "node" ],
            "old_state" : { "value" : { "ANY" : "ANY" } },
            "new_state" : { "value" : { "2" : "2" } }
          }
        }
      ],
      "DO" : [
        { "mail_to_users_of_role" : {
            "roles" : { "value" : { "4" : "4" } },
            "subject" : "A post have been saved as Draft at [site:name]",
            "message" : "A post titled [node:title] have been saved into Draft by user [node:author]. \\r\\n\\r\\nYou can view it here : [node:url] (you must logged in to see the post).\\r\\n\\r\\nCheers."
          }
        }
      ]
    }
  }');
  return $items;
}
