<?php get_header(); ?>

	<?php get_sidebar(); ?>	
	
	<section class="left-col">
			
		<?php $archive_year  = get_the_time('Y'); ?>
		<?php $archive_month = get_the_time('m'); ?>	
		<h2 class="section-title"><?php the_time('F Y'); ?></h2>
		
		<?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
		<div class="block long summary group">
			<figure>
				<a href="<?php the_permalink();?>"><img src="<?php the_field('thumbnail_image'); ?>" alt="" /></a>
			</figure>
			<div class="info">
				<h3 class="post-title"><a href="<?php the_permalink();?>" title="<?php the_title();?>"><?php the_title();?></a></h3>
				<h4 class="post-meta">By <?php the_author(); ?>, filed under <?php the_category(', ')?></h4>
				<?php if(get_field('thumbnail_paragraph') != ""): ?>
					<p><?php the_field('thumbnail_paragraph'); ?>... <a class="readmore" href="<?php the_permalink();?>">Read More</a></p>
				<?php else : ?>
					<?php the_excerpt();?>
				<?php endif; ?>
			</div><!-- end info -->
		</div><!-- end block long summary -->
		<?php endwhile; ?>		
		
		
		<div class="pagination numbers">
			<?php
			global $wp_query;
			
			$big = 999999999; // need an unlikely integer
			
			echo paginate_links( array(
				'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
				'format' => '?paged=%#%',
				'current' => max( 1, get_query_var('paged') ),
				'total' => $wp_query->max_num_pages
			) );
			?>
		</div><!-- end pagination -->

	
	</section><!-- end left-col -->
	
<?php get_footer(); ?>
