<?php
if ( function_exists('register_sidebar') )
{
	register_sidebar(array(
	  'name' => 'Primary Sidebar',
	  'id' => 'primary-sidebar',
	  'description' => 'The first distinctive sidebar blocks in the blog page',
	  'before_title' => '<h3>',
	  'after_title' => '</h3>'
	));
}

function custom_excerpt_length( $length ) {
	return 30;
}
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );

// Replaces the excerpt "more" text by a link
function new_excerpt_more($more) {
       global $post;
	return '... <a class="readmore" href="'. get_permalink($post->ID) . '"> Read more</a>';
}
add_filter('excerpt_more', 'new_excerpt_more');

add_filter('wp_list_categories','highlight_single_posts_categories');
function highlight_single_posts_categories($output) {
if(is_single()) :
$categories = wp_get_post_categories(get_the_ID());
foreach ($categories as $catid) {
$cat = get_category($catid);
$cats[] = $cat->cat_ID;
 }
if($cats) { foreach($cats as $value) {
	if(preg_match('#item-' . $value . '">#', $output)) {
	$output = str_replace('item-' . $value . '">', 'item-' . $value . ' current-cat">', $output);
	}
	}
}
endif;
return $output;
}

function wpb_set_post_views($postID) {
    $count_key = 'wpb_post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
    }else{
        $count++;
        update_post_meta($postID, $count_key, $count);
    }
}
//To keep the count accurate, lets get rid of prefetching
remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);

function wpb_track_post_views ($post_id) {
    if ( !is_single() ) return;
    if ( empty ( $post_id) ) {
        global $post;
        $post_id = $post->ID;    
    }
    wpb_set_post_views($post_id);
}
add_action( 'wp_head', 'wpb_track_post_views');

function wpb_get_post_views($postID){
    $count_key = 'wpb_post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
        return "0 View";
    }
    return $count.' Views';
}

?>
