<!DOCTYPE html>
<!--[if IE 6]>
<html id="ie6" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 7]>
<html id="ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html id="ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 6) | !(IE 7) | !(IE 8)  ]><!-->

<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<!-- <meta name="viewport" content="width=1000"> -->
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?php bloginfo('name'); ?> &raquo; <?php wp_title(); ?></title>

<!--[if lt IE 9]><html class="ie"><![endif]-->
<link rel="stylesheet" href="<?php bloginfo('template_directory'); ?>/css/flexslider.css" type="text/css" media="screen" />
<link href="<?php bloginfo('template_directory'); ?>/style.css" rel="stylesheet" type="text/css" />
<link href="<?php bloginfo('template_directory'); ?>/style-respond.css" rel="stylesheet" type="text/css" />

<link rel="shortcut icon" type="image/x-icon" href="<?php bloginfo('template_directory'); ?>/favicon.ico">

<link href="http://www.ntucmedia.org.sg/feed/newsfeed.xml" rel="alternate" type="application/rss+xml" title="SG@Work feeds link" />

<script src="<?php bloginfo('template_directory'); ?>/js/modernizr-2.0.6.min.js"></script>
<script src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.js"></script>

<script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/js/jquery.flexslider-min.js"></script>

<!--[if lt IE 9]>
<script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/js/response.min.js"></script>
<![endif]-->

<!--[if lte IE 9]>
<link href="<?php bloginfo('template_directory'); ?>/style-ie.css" rel="stylesheet" type="text/css" />
<![endif]-->
  
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<header class="header">
		<div class="wrapper group">
			<?php echo drawAdsPlace(array('id'=>1)); ?>
			
			<h1 class="logo"><a href="<?php bloginfo('url'); ?>"><img src="<?php bloginfo('template_directory'); ?>/images/logo.png" alt="NTUC News Logo"/></a></h1>
			
			<a class="nav-toggle" onclick="return false;">Navigate</a>
			
			<a class="search-web" onclick="return false;">Search Website</a>
								
			<section class="search-form">
				<form action="<?php echo bloginfo('home'); ?>" method="get" id="search-block-form" accept-charset="UTF-8">
					<input type="text" name="s" id="query" size="40" value="" action="<?php echo bloginfo('template_directory'); 
		?>/include/js_suggest/suggest.php" 
		columns="2" autocomplete="off" delay="1500">
					<input type="hidden" name="search" value="1" />
				</form>
			</section>
			
		</div><!-- end wrapper -->
	
		<nav class="group" role="navigation">
			<div class="wrapper">
				<a class="home-icon" href="<?php bloginfo('url'); ?>">Home</a>
				
				<ul>
					<?php wp_list_categories('exclude=1,9,10&title_li=&orderby=ID'); ?> <!-- Exclude Featured -->
				</ul>
			</div><!-- end wrapper -->
		</nav>
	
	</header>
		
	<section class="content-wrap group">
	
		<?php echo drawAdsPlace(array('id'=>3)); ?>
		
		<?php if(!is_page('6') || !post_type_exists( 'post' ) ) { //If not Homepage ?>
		<div class="selector mobile">	
			<div class="group">
				<h3 class="label">Archives:</h3>
				<div class="select-btn">Select Month</div>
				<div class="month_select">
					<ul id="myid">
					<?php wp_get_archives( array( 'type' => 'monthly', 'limit' => 12 ) ); ?>
					</ul>
				</div><!-- month_select -->
			</div><!-- end group -->
		</div><!-- end selector -->
		<?php } ?>
		
