<?php 
/* Template Name: Home Page */ 
?>

<?php get_header(); ?>

	<?php get_sidebar(); ?>	
	
	<section class="left-col">
	
	<?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
	
		<h2 class="section-title"><?php the_field('main_carousel_title'); ?></h2>
						
		<article class="main-carousel group shadow">
			<div class="flexslider">
				<ul class="slides">
					<?php if( get_field('main_carousel') ): ?>
						<?php while( has_sub_field('main_carousel') ): ?> 
							<li class="group">
								<a href="<?php the_sub_field('article_link'); ?>">
									<figure>
										<img src="<?php the_sub_field('image'); ?>" alt="<?php the_sub_field('article_title'); ?>" />
									</figure>
								</a>
									<div class="caption">
										<h3><?php the_sub_field('article_title'); ?></h3>			    	
				   						<p><?php the_sub_field('excerpt'); ?></p>
									</div><!-- end caption -->
							</li>
						<?php endwhile; ?>
					<?php endif; ?>
				</ul>
			</div><!-- end flexslider -->		
		</article><!-- end carousel -->
	
	<?php endwhile; ?>
		
		<article class="block group">
			<div class="column left">
				<h2>People</h2>
				<?php
					wp_reset_query();
					// The Query
					$args = array(
						'category_name'=>'people',
						'posts_per_page'=>1
					);
					$query = new WP_Query( $args );
					
					// The Loop
					if ( $query->have_posts() ): while ( $query->have_posts() ) : $query->the_post();
				?>
				<figure>
					<a href="<?php the_permalink(); ?>"><img src="<?php echo get_field('thumbnail_image'); ?>" alt="" /></a>
				</figure>
				<h3><?php the_title(); ?></h3>
				<?php the_excerpt(); ?>
				<?php endwhile; ?>
				<?php else: ?>
				<figure>
					<a href="#>"><img src="<?php bloginfo('template_directory'); ?>/images/dummy-3.jpg" alt="" /></a>
				</figure>
				<h3>Nunc eleifend convallis velit</h3>
				<p>Pellentesque non magna vitae magna laoreet condimentum. Nam malesuada tempor eros, sit amet ornare justo tristique magna vitae... <a class="readmore" href="#">Read More</a></p>
				<?php endif; ?>
				<ul class="links">
					<?php
						wp_reset_query();
						// The Query
						$args = array(
							'category_name'=>'people',
							'posts_per_page'=>4,
							'offset'=>1
						);
						$query = new WP_Query( $args );
						
						// The Loop
						if ( $query->have_posts() ): while ( $query->have_posts() ) : $query->the_post();
					?>
					<li><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
					<?php endwhile; ?>
					<?php else: ?>
					<li>No other news in this category.</li>
					<?php endif; ?>
				</ul>
			</div><!-- end left -->
			
			<div class="column">
				<h2>Insights</h2>
				<?php
					wp_reset_query();
					// The Query
					$args = array(
						'category_name'=>'insights',
						'posts_per_page'=>1
					);
					$query = new WP_Query( $args );
					
					// The Loop
					if ( $query->have_posts() ): while ( $query->have_posts() ) : $query->the_post();
				?>
				<figure>
					<a href="<?php the_permalink(); ?>"><img src="<?php echo get_field('thumbnail_image'); ?>" alt="" /></a>
				</figure>
				<h3><?php the_title(); ?></h3>
				<?php the_excerpt(); ?>
				<?php endwhile; ?>
				<?php else: ?>
				<figure>
					<a href="#"><img src="<?php bloginfo('template_directory'); ?>/images/dummy-3.jpg" alt="" /></a>
				</figure>
				<h3>Nunc eleifend convallis velit</h3>
				<p>Pellentesque non magna vitae magna laoreet condimentum. Nam malesuada tempor eros, sit amet ornare justo tristique magna vitae... <a class="readmore" href="#">Read More</a></p>
				<?php endif; ?>
				<ul class="links">
					<?php
						wp_reset_query();
						// The Query
						$args = array(
							'category_name'=>'insights',
							'posts_per_page'=>4,
							'offset'=>1
						);
						$query = new WP_Query( $args );
						
						// The Loop
						if ( $query->have_posts() ): while ( $query->have_posts() ) : $query->the_post();
					?>
					<li><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
					<?php endwhile; ?>
					<?php else: ?>
					<li>No other news in this category.</li>
					<?php endif; ?>
				</ul>
			</div><!-- end left -->
		</article>
		
		<article class="block video group">
			<h2>Videos</h2>
			<?php
				wp_reset_query();
				// The Query
				$args = array(
					'category_name'=>'videos',
					'posts_per_page'=>1
				);
				$query = new WP_Query( $args );
				
				// The Loop
				if ( $query->have_posts() ): while ( $query->have_posts() ) : $query->the_post();
			?>
			<?php if (get_field('youtube_video')!=""): ?>
			<div class="left">
				<iframe width=100% height="236" src="<?php echo get_field('youtube_video'); ?>" frameborder="0" allowfullscreen></iframe>
			</div><!-- end left -->
			<?php endif; ?>
			
			<div class="info">
				<h3><?php the_title(); ?></h3>
				<?php the_excerpt(); ?>
			</div><!-- end info -->
			<?php endwhile; else: ?>
			<div class="left">
				<iframe width=100% height="236" src="//www.youtube.com/embed/sE5nDbyRHQc?rel=0" frameborder="0" allowfullscreen></iframe>
			</div><!-- end left -->
			
			<div class="info">
				<h3>Cras vitae metus quam</h3>
				<p>Pellentesque non magna vitae magna laoreet condimentum. Nam malesuada tempor eros, sit amet ornare justo tristique magna vitae Aliquam facilisis suscipit posuere. Curabitur auctor pharetra rhoncus.</p>
			</div><!-- end info -->
			<?php endif; ?>
		</article>
		
		<article class="block master group">
			<h2>What's On</h2>
			<?php
				// The Query
				$args = array(
					'category_name'=>'whats-on',
					'posts_per_page'=>1
				);
				$query = new WP_Query( $args );
				
				// The Loop
				if ( $query->have_posts() ): while ( $query->have_posts() ) : $query->the_post();
			?>
			<div class="left">
				<figure>
					<a href="<?php the_permalink(); ?>"><img src="<?php echo get_field('thumbnail_image'); ?>" alt="" /></a>
				</figure>
				<h3><?php the_title(); ?></h3>
				<?php the_excerpt(); ?>
			</div>
			<?php endwhile; ?>
			<?php else: ?>
			<div class="left">
				<figure>
					<a href="#"><img src="<?php bloginfo('template_directory'); ?>/images/dummy-2.jpg" alt="" /></a>
				</figure>
				<h3>Proin massa mauris ultrices vitae</h3>
				<p>Pellentesque non magna vitae magna laoreet condimentum. Nam malesuada tempor eros, sit amet ornare justo tristique magna vitae... <a class="readmore" href="#">Read More</a></p>
			</div>
			<?php endif; ?>
			<ul class="links">
				<?php
					wp_reset_query();
					// The Query
					$args = array(
						'category_name'=>'whats-on',
						'posts_per_page'=>7,
						'offset'=>1
					);
					$query = new WP_Query( $args );
					
					// The Loop
					if ( $query->have_posts() ): while ( $query->have_posts() ) : $query->the_post();
				?>
				<li><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
				<?php endwhile; ?>
				<?php else: ?>
				<li>No other news in this category.</li>
				<?php endif; ?>
			</ul>
		</article>
		
		<a class="ad square mobile" href="#"><img src="<?php bloginfo('template_directory'); ?>/images/ad-square.jpg" alt="Name of Ad"/></a>
		
		
		
		<article class="block long group">
			<h2>Comments</h2>
			
			<div class="flexslider">
				<ul class="slides">
					<?php
						wp_reset_query();
						// The Query
						$args = array(
							'category_name'=>'comments',
							'posts_per_page'=>3
						);
						$query = new WP_Query( $args );
						
						// The Loop
						if ( $query->have_posts() ): while ( $query->have_posts() ) : $query->the_post();
					?>
					<li>
						<figure>
							<a href="<?php the_permalink(); ?>"><img src="<?php echo get_field('thumbnail_image'); ?>" alt="" /></a>
						</figure>
						<div class="info">
							<h3><?php the_title(); ?></h3>
							<?php the_excerpt(); ?>
						</div><!-- end info -->
					</li>
						<?php endwhile; else: ?>
					<li>
						<figure>
							<a href="#"><img src="<?php bloginfo('template_directory'); ?>/images/dummy-1.jpg" alt="" /></a>
						</figure>
						<div class="info">
							<h3>Cras vitae metus quam</h3>
							<p>Pellentesque non magna vitae magna laoreet condimentum. Nam malesuada tempor eros, sit amet ornare justo tristique magna vitae Aliquam facilisis suscipit posuere. Curabitur auctor pharetra rhoncus. <a class="readmore" href="#">Read More</a></p>
						</div><!-- end info -->
					</li>
					<?php endif; ?>
				</ul>
			</div><!-- end flexslider -->
		</article>
					
	</section><!-- end left-col -->
			
<?php get_footer(); ?>